 ; Ŀ
 ;   DN - find nesting for a selected block.                               
 ;   Copyright 1993, 2005, 2006 by Rocket Software Ltd.                    
 ;   For those times when intuition and software just don't mesh.          
 ; 

 ; Ŀ
 ;   Subroutine Lbox - display a list of strings in a dialog box.          
 ;   Arguments: Styldt, the list of strings to display.                    
 ;              Dclfil, the dcl file name.                                 
 ;              Dclnam, the dialog box name in the dcl file.               
 ;              Prom, the type for the number of things found prompt.      
 ;              Dianam, the dialog box title.                              
 ;   Returns a text string or nil.                                         
 ; 
 (DEFUN LBOX (styldt dclfil dclnam prom dianam / fpath dcl_id num numf filnam
                                                       fnam malist findx ret)
  (setq dcl_id (load_dialog dclfil))
  (new_dialog dclnam dcl_id)      ; must come before data for list box
  (set_tile "diabox" dianam)
 ; Ŀ
 ;   Make the Style list for the list box.                                 
 ; 
  (start_list "the_list")         ; read ltype data list into list box
  (setq num 0)
  (while (setq stylnm (nth num styldt))
         (add_list stylnm)
         (setq malist (cons stylnm malist))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa num) " " prom))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (selok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a text string or nil.                                          
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Lbox end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Selok - if OK was pressed, see if a file name was          
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN SELOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (set_tile "babtext" "You must select a name."))
 lisval)
 ; Ŀ
 ;   Selok end.                                                            
 ; 

 ; ͻ
 ;   Dwasl - subroutine - deal with a single list: check each entity       
 ;   after the first one to see if it is a list, if not make it into one.  
 ; ͼ
  (DEFUN DWASL (liss / num ent entt)
   (setq num 1)
   (while (setq ent (nth num liss))            ; while there is an entity
          (if (listp ent)                      ; is the entity a list?
              (setq entt (dwasl ent))          ; yes then recurse
              (setq entt (assoc ent bblist)))  ; no then get from main list
          (setq liss (subst entt ent liss))    ; update the list
          (setq num (1+ num)))                 ; go to next entity
   (setq liss liss))                           ; return list
 ; ͻ
 ;   Dwasl end.                                                            
 ; ͼ

 ; ͻ
 ;   Dnest - subroutine - show block nesting for a given block.            
 ;                                                                         
 ;   Go down (recurse if the entity in question is a list) adding the      
 ;   first element of each list to string-so-far, don't add while          
 ;   checking within a list, when you hit bottom or find the name of the   
 ;   block you are looking for write the string to the list.               
 ;   Then go on to the next element of the current list, when you come     
 ;   to the end of a list return (back up one step) which should return    
 ;   the string-so-far and position-in-list variables to their earlier     
 ;   values.                                                               
 ;                                                                         
 ;   Dnest takes two arguments: the nesting-so-far string and the entity   
 ;   being examined.  It returns nothing - absolutely nothing! - but it    
 ;   alters Nests (the list of nesting description strings) if required.   
 ;                                                                         
 ; ͼ
  (DEFUN DNEST (nestring liss / num ent)
   (if (/= nestring "")
       (setq nestring (strcat nestring "/")))
   (if (= (type (nth 0 liss)) 'STR)
       (setq nestring (strcat nestring (nth 0 liss))))  ; add name to string
   (setq num 0)
   (while (setq ent (nth num liss))        ; while there is an entity
          (if (listp ent)                  ; is the entity a list?
              (dnest nestring ent)         ; yes then recurse
              (progn                       ; not a list (i.e. a name)
                   (if (equal ent bname)   ; if it's the block we're after
                       (setq nests (append nests (list nestring))))))
          (setq num (1+ num))))            ; go to next entity, dnest ends
 ; ͻ
 ;   Dnest.                                                                
 ; ͼ

 ; ͻ 
 ;   DN: the main program.                                                 
 ; ͼ 
 (Defun C:DN (/ blok blist bblist num nests nest2 malist bnamb)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   Step through the block table making a list of lists composed of the   
 ;   name of each block and the names of its subentities which are blocks. 
 ; 
  (setq rewind t)                                   ; set the rewind flag
  (while (setq blok (tblnext "block" rewind))       ; next block in table
         (setq rewind ())                           ; clear the rewind flag
 ; Ŀ
 ;   List the block name so as to have something to append subentity       
 ;   block names to.                                                       
 ; 
         (setq blist (list (setq bnamb (cdr (assoc 2 blok)))))   ; block name
 ; Ŀ
 ;   Make a list of just block names.                                      
 ; 
         (setq malist (cons bnamb malist))
 ; Ŀ
 ;   Get the name of the first subentity.                                  
 ; 
         (setq namm (cdr (assoc -2 blok)))          ; entity name
         (setq bleent (entget namm))                ; and entity data
 ; Ŀ
 ;   If the subentity is a block then append its name to the list          
 ;   starting with the block name.                                         
 ;   (Which will be appended to the list of block lists)                   
 ; 
         (if (= (cdr (assoc 0 bleent)) "INSERT")    ; if it's a block
             (setq blist (append blist (list (cdr (assoc 2 bleent))))))
 ; Ŀ
 ;   Step through the subentities, checking to see if each one is a block. 
 ; 
         (while (setq namm (entnext namm))          ; next entity after bl name
                (setq bleent (entget namm))         ; entity data
 ; Ŀ
 ;   If the subentity is a block then append its name to the list          
 ;   starting with the block name.                                         
 ; 
                (if (= (cdr (assoc 0 bleent)) "INSERT") ; if subent is a block
                    (setq blist (append blist (list (cdr (assoc 2 bleent)))))))
 ; Ŀ
 ;   Have now reached the end of the subentities for the block.            
 ;   Append the block list (blist) to the list of block lists (bblist).    
 ; 
         (setq bblist (append bblist (list blist))))
 ; Ŀ
 ;   End of the outer block table while loop.                              
 ; 
 ; Ŀ
 ;   Now find the nesting for the desired blocks:                          
 ;   Remake the list substituting block lists for block names in block     
 ;   lists.                                                                
 ; 
  (while (not (equal bbsav bblist))
         (setq bbsav bblist)
 ; Ŀ
 ;   At this point bbsav = bblist.                                         
 ;   If they are still equal after the loop then it is finished.           
 ; 
        (setq nnum 0)
        (While (setq blist (nth nnum bblist))     ; get next blist from bblist
               (setq bblist (subst (dwasl blist) blist bblist)) ; put list back
               (setq nnum (1+ nnum))))            ; incr pos in bblist
 ; Ŀ
 ;   Call the dialog box to get a text style name from those defined       
 ;   in the drawing.                                                       
 ; 
  (setq malist (acad_strlsort malist))
  (setq bname (lbox malist "lf.dcl" "lf" "Blocks." "Block to De-Nest"))
 ; Ŀ
 ;   Call dnest to find block nesting.                                     
 ; 
  (if (assoc bname bblist)
      (progn
           (dnest "" bblist)                ; call dnest to read list
 ; Ŀ
 ;   Remove duplicate strings from Nests.                                  
 ; 
           (setq num 0)
           (while (setq namm (nth num nests))
                  (setq num (1+ num))
                  (setq nests (subst "" namm nests))
                  (if (/= namm "")
                      (setq nest2 (append nest2 (list namm)))))
 ; Ŀ
 ;   And print the list of nesting strings.                                
 ; 
           (setq nnum 0)
           (write-line "\n")
           (while (setq lll (nth nnum nest2))
                  (write-line lll)
                  (setq nnum (1+ nnum))) 
           (setq nests ())
           (setq nest2 ()))
      (if bname (write-line "No such block")))
 (princ))